'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 8 October 2006 at 11:18:31 pm'!

!CCodeGenerator methodsFor: 'C translation' stamp: 'ar 12/18/2004 18:10'!
generateAddressOf: node on: aStream indent: level
	"Generate the C code for this message onto the given stream."
	aStream nextPutAll: '((int)&'.
	self emitCExpression: node args first on: aStream.
	aStream nextPutAll: ')'.
! !

!CCodeGenerator methodsFor: 'C translation' stamp: 'ar 12/18/2004 18:00'!
initializeCTranslationDictionary 
	"Initialize the dictionary mapping message names to actions for C code generation."

	| pairs |
	pairs _ #(
	#&				#generateAnd:on:indent:
	#|				#generateOr:on:indent:
	#and:			#generateSequentialAnd:on:indent:
	#or:			#generateSequentialOr:on:indent:
	#not			#generateNot:on:indent:

	#+				#generatePlus:on:indent:
	#-				#generateMinus:on:indent:
	#*				#generateTimes:on:indent:
	#/				#generateDivide:on:indent:
	#//				#generateDivide:on:indent:
	#\\				#generateModulo:on:indent:
	#<<				#generateShiftLeft:on:indent:
	#>>				#generateShiftRight:on:indent:
	#min:			#generateMin:on:indent:
	#max:			#generateMax:on:indent:

	#bitAnd:		#generateBitAnd:on:indent:
	#bitOr:			#generateBitOr:on:indent:
	#bitXor:			#generateBitXor:on:indent:
	#bitShift:		#generateBitShift:on:indent:
	#bitInvert32	#generateBitInvert32:on:indent:

	#<				#generateLessThan:on:indent:
	#<=				#generateLessThanOrEqual:on:indent:
	#=				#generateEqual:on:indent:
	#>				#generateGreaterThan:on:indent:
	#>=				#generateGreaterThanOrEqual:on:indent:
	#~=				#generateNotEqual:on:indent:
	#==				#generateEqual:on:indent:
	#~~				#generateNotEqual:on:indent:
	#isNil			#generateIsNil:on:indent:
	#notNil			#generateNotNil:on:indent:

	#whileTrue: 	#generateWhileTrue:on:indent:
	#whileFalse:	#generateWhileFalse:on:indent:
	#whileTrue 		#generateDoWhileTrue:on:indent:
	#whileFalse		#generateDoWhileFalse:on:indent:
	#to:do:			#generateToDo:on:indent:
	#to:by:do:		#generateToByDo:on:indent:

	#ifTrue:		#generateIfTrue:on:indent:
	#ifFalse:		#generateIfFalse:on:indent:
	#ifTrue:ifFalse:	#generateIfTrueIfFalse:on:indent:
	#ifFalse:ifTrue:	#generateIfFalseIfTrue:on:indent:

	#at:				#generateAt:on:indent:
	#at:put:			#generateAtPut:on:indent:
	#basicAt:		#generateAt:on:indent:
	#basicAt:put:	#generateAtPut:on:indent:

	#integerValueOf:	#generateIntegerValueOf:on:indent:
	#integerObjectOf:	#generateIntegerObjectOf:on:indent:
	#isIntegerObject: 	#generateIsIntegerObject:on:indent:
	#cCode:				#generateInlineCCode:on:indent:
	#cCode:inSmalltalk:	#generateInlineCCode:on:indent:
	#cCoerce:to:			#generateCCoercion:on:indent:
	#preIncrement		#generatePreIncrement:on:indent:
	#preDecrement		#generatePreDecrement:on:indent:
	#inline:				#generateInlineDirective:on:indent:
	#sharedCodeNamed:inCase:	#generateSharedCodeDirective:on:indent:
	#asFloat				#generateAsFloat:on:indent:
	#asInteger			#generateAsInteger:on:indent:
	#anyMask:			#generateBitAnd:on:indent:
	#raisedTo:			#generateRaisedTo:on:indent:
	#touch:				#generateTouch:on:indent:

	#perform:						#generatePerform:on:indent:
	#perform:with:					#generatePerform:on:indent:
	#perform:with:with:				#generatePerform:on:indent:
	#perform:with:with:with:		#generatePerform:on:indent:
	#perform:with:with:with:with:	#generatePerform:on:indent:
		
	#addressOf:			#generateAddressOf:on:indent:

	).
	translationDict _ Dictionary new: pairs size // 2.

	1 to: pairs size by: 2 do: [:i |
		translationDict at: (pairs at: i) put: (pairs at: i + 1)].
! !


!ObjectMemory methodsFor: 'allocation' stamp: 'wbk 6/8/2006 22:50'!
recycleContextIfPossible: cntxOop 
	"If possible, save the given context on a list of free contexts to 
	be recycled."
	"Note: The context is not marked free, so it can be reused 
	with minimal fuss. The recycled context lists are cleared at 
	every garbage collect."
	| header |
	self inline: true.
	"only recycle young contexts (which should be most of them)"
	cntxOop >= youngStart
		ifTrue: [header := self baseHeader: cntxOop.
			(self isMethodContextHeader: header)
				ifTrue: ["It's a young context, alright."
					self "Clear the slot that indicates it was compiled"
						storePointerUnchecked: 4
						ofObject: cntxOop
						withValue: nilObj.
					(header bitAnd: SizeMask) = SmallContextSize
						ifTrue: ["Recycle small contexts"
							self storePointerUnchecked: 0 ofObject: cntxOop withValue: freeContexts.
							freeContexts := cntxOop].
					(header bitAnd: SizeMask) = LargeContextSize
						ifTrue: ["Recycle large contexts"
							self storePointerUnchecked: 0 ofObject: cntxOop withValue: freeLargeContexts.
							freeLargeContexts := cntxOop]]]! !


!Interpreter methodsFor: 'message sending' stamp: 'wbk 4/18/2004 20:57'!
findNewMethodInClass: class 
	"Find the compiled method to be run when the current messageSelector is sent to the given class, setting the values of 'newMethod' and 'primitiveIndex'."

	| ok |
	self inline: false.
	ok := self 
				lookupInMethodCacheSel: messageSelector
				class: class.
	ok ifFalse: 
			["entry was not found in the cache; look it up the hard way"

			self lookupMethodInClass: class.
			lkupClass := class.
			self exuperyLookupMethodHook.
			self addNewMethodToCache]! !

!Interpreter methodsFor: 'message sending' stamp: 'wbk 10/3/2006 23:18'!
internalExecuteNewMethod
	| localPrimIndex delta nArgs |
	self inline: true.

	" Call a compiled method if it's availible"	
	newNativeMethod = nil ifFalse:
		[self externalizeIPandSP.
		self exuperyCallMethod.
		self internalizeIPandSP.
		^ self].

	localPrimIndex := primitiveIndex.
	localPrimIndex > 0
		ifTrue: [(localPrimIndex > 255
					and: [localPrimIndex < 520])
				ifTrue: ["Internal return instvars"
					localPrimIndex >= 264
						ifTrue: [^ self internalPop: 1 thenPush: (self fetchPointer: localPrimIndex - 264 ofObject: self internalStackTop)]
						ifFalse: ["Internal return constants"
							localPrimIndex = 256 ifTrue: [^ nil].
							localPrimIndex = 257 ifTrue: [^ self internalPop: 1 thenPush: trueObj].
							localPrimIndex = 258 ifTrue: [^ self internalPop: 1 thenPush: falseObj].
							localPrimIndex = 259 ifTrue: [^ self internalPop: 1 thenPush: nilObj].
							^ self internalPop: 1 thenPush: (self integerObjectOf: localPrimIndex - 261)]]
				ifFalse: [self externalizeIPandSP.
					"self primitiveResponse. <-replaced with  manually inlined code"
					DoBalanceChecks
						ifTrue: ["check stack balance"
							nArgs := argumentCount.
							delta := stackPointer - activeContext].
					successFlag := true.
					self dispatchFunctionPointer: primitiveFunctionPointer. "branch direct to prim function from address stored in mcache"
					DoBalanceChecks
						ifTrue: [(self balancedStack: delta afterPrimitive: localPrimIndex withArgs: nArgs)
								ifFalse: [self printUnbalancedStack: localPrimIndex]].
					(self exuperyIsNativeContext: activeContext) ifTrue: [self exuperyReturn].
					self internalizeIPandSP.
					successFlag
						ifTrue: [self browserPluginReturnIfNeeded.
							^ nil]]].
	"if not primitive, or primitive failed, activate the method"
	self internalActivateNewMethod.

	"check for possible interrupts at each real send"
	self internalQuickCheckForInterrupts! !

!Interpreter methodsFor: 'message sending' stamp: 'wbk 4/18/2004 20:57'!
internalFindNewMethod
	"Find the compiled method to be run when the current messageSelector is sent to the class 'lkupClass', setting the values of 'newMethod' and 'primitiveIndex'."

	| ok |
	self inline: true.
	ok := self 
				lookupInMethodCacheSel: messageSelector
				class: lkupClass.
	ok ifFalse: 
			["entry was not found in the cache; look it up the hard way"

			self externalizeIPandSP.
			self lookupMethodInClass: lkupClass.
			self exuperyLookupMethodHook.
			self internalizeIPandSP.
			self addNewMethodToCache]! !

!Interpreter methodsFor: 'processes' stamp: 'wbk 10/3/2006 22:06'!
internalQuickCheckForInterrupts
	"Internal version of quickCheckForInterrupts for use within jumps."

	self inline: true.
	((interruptCheckCounter := interruptCheckCounter - 1) <= 0) ifTrue: [
		self externalizeIPandSP.
		self checkForInterrupts.

		(self exuperyIsNativeContext: activeContext) ifTrue: [self exuperyReturn].

		self browserPluginReturnIfNeeded.

		self internalizeIPandSP].
! !

!Interpreter methodsFor: 'debug support' stamp: 'JMM 10/8/2006 16:52'!
okayActiveProcessStack

	| cntxt header|

	cntxt := activeContext.	
	[cntxt = nilObj] whileFalse: [
		self okayFields: cntxt.	header := cntxt at: 0.
		((cntxt at: 5) = 1 and: [((header >> 12) bitAnd: 16r1F) = 14 and: [(cntxt at: 2) < 1000 and: [(cntxt at: 2) ~= 1]]]) ifTrue:
			[self error: 'Bad instruction pointer in a native method context'].

		cntxt := (self fetchPointer: SenderIndex ofObject: cntxt).	
	].! !

!Interpreter methodsFor: 'debug support' stamp: 'wbk 3/1/2006 21:45'!
okayFields: oop
	"If this is a pointers object, check that its fields are all okay oops."

	| i fieldOop |
	(oop = nil or: [oop = 0]) ifTrue: [ ^true ].
	(self isIntegerObject: oop) ifTrue: [ ^true ].
	self okayOop: oop.
	self oopHasOkayClass: oop.
	(self isPointers: oop) ifFalse: [ ^true ].
	(self isContextHeader: (self baseHeader: oop))
		ifTrue: [i := CtxtTempFrameStart + (self fetchStackPointerOf: oop) - 1]
		ifFalse: [i := (self lengthOf: oop) - 1].
	[i >= 0] whileTrue: [
		fieldOop := self fetchPointer: i ofObject: oop.
		(self isIntegerObject: fieldOop) ifFalse: [
			self okayOop: fieldOop.
			self oopHasOkayClass: fieldOop.
		].
		i := i - 1.
	].! !

!Interpreter methodsFor: 'contexts' stamp: 'wbk 2/18/2006 20:18'!
isContextHeader: aHeader
	self inline: true.
	^ ((aHeader >> 12) bitAnd: 16r1F) = 13				"BlockContext"
		or: [((aHeader >> 12) bitAnd: 16r1F) = 14		"MethodContext"
		or: [((aHeader >> 12) bitAnd: 16r1F) = 15		"ExuperyBlockContext"
		or: [((aHeader >> 12) bitAnd: 16r1F) = 4]]]		"PseudoContext"! !

!Interpreter methodsFor: 'contexts' stamp: 'wbk 10/2/2006 22:17'!
newActiveContext: aContext
	"Note: internalNewActiveContext: should track changes to this method."

	self storeContextRegisters: activeContext.
	(aContext < youngStart) ifTrue: [ self beRootIfOld: aContext ].
	activeContext := aContext.
	self fetchContextRegisters: aContext.

	newNativeMethod := self exuperyCompiledReturnAddress! !

!Interpreter methodsFor: 'return bytecodes' stamp: 'JMM 10/8/2006 17:00'!
commonReturn
	"Note: Assumed to be inlined into the dispatch loop."

	| nilOop thisCntx contextOfCaller localCntx localVal unwindMarked |
	self inline: true.
	self sharedCodeNamed: 'commonReturn' inCase: 120.

	nilOop := nilObj. "keep in a register"
	thisCntx := activeContext.
	localCntx := localReturnContext.
	localVal := localReturnValue.

	"make sure we can return to the given context"
	((localCntx = nilOop) or:
	 [(self fetchPointer: InstructionPointerIndex ofObject: localCntx) = nilOop]) ifTrue: [
		"error: sender's instruction pointer or context is nil; cannot return"
		^self internalCannotReturn: localVal].

	"If this return is not to our immediate predecessor (i.e. from a method to its sender, or from a block to its caller), scan the stack for the first unwind marked context and inform this context and let it deal with it. This provides a chance for ensure unwinding to occur."
	thisCntx := self fetchPointer: SenderIndex ofObject: activeContext.

	"Just possibly a faster test would be to compare the homeContext and activeContext - they are of course different for blocks. Thus we might be able to optimise a touch by having a different returnTo for the blockreteurn (since we know that must return to caller) and then if active ~= home we must be doing a non-local return. I think. Maybe."
	[thisCntx = localCntx] whileFalse: [
		thisCntx = nilOop ifTrue:[
			"error: sender's instruction pointer or context is nil; cannot return"
			^self internalCannotReturn: localVal].
		"Climb up stack towards localCntx. Break out to a send of #aboutToReturn:through: if an unwind marked context is found"
		unwindMarked := self isUnwindMarked: thisCntx.
		unwindMarked ifTrue:[
			"context is marked; break out"
			^self internalAboutToReturn: localVal through: thisCntx].
		thisCntx := self fetchPointer: SenderIndex ofObject: thisCntx.
 ].

	"If we get here there is no unwind to worry about. Simply terminate the stack up to the localCntx - often just the sender of the method"
	thisCntx := activeContext.
	[thisCntx = localCntx]
		whileFalse:
		["climb up stack to localCntx"
		contextOfCaller := self fetchPointer: SenderIndex ofObject: thisCntx.

		"zap exited contexts so any future attempted use will be caught"
		self storePointerUnchecked: SenderIndex ofObject: thisCntx withValue: nilOop.
		self storePointerUnchecked: InstructionPointerIndex ofObject: thisCntx withValue: nilOop.
		reclaimableContextCount > 0 ifTrue:
			["try to recycle this context"
			reclaimableContextCount := reclaimableContextCount - 1.
			self recycleContextIfPossible: thisCntx].
		thisCntx := contextOfCaller].

	activeContext := thisCntx.
	(thisCntx < youngStart) ifTrue: [ self beRootIfOld: thisCntx ].

	self internalFetchContextRegisters: thisCntx.  "updates local IP and SP"
	localIP preIncrement.
	self internalPush: localVal.
	
	"Returns into a compiled method, if the method is compiled"
	(self exuperyIsNativeContext: activeContext) ifTrue: 
		[self externalizeIPandSP. 
		self exuperyReturn.
		self internalizeIPandSP.
		localIP preIncrement.].
	currentBytecode :=  self byteAtPointer: localIP
! !

!Interpreter methodsFor: 'compiler support' stamp: 'wbk 3/11/2005 23:27'!
initCompilerHooks
	"Initialize hooks for the 'null compiler'"

	self cCode: 'compilerHooks[1]= nullCompilerHook'.
	self cCode: 'compilerHooks[2]= nullCompilerHook'.
	self cCode: 'compilerHooks[3]= nullCompilerHook'.
	self cCode: 'compilerHooks[4]= nullCompilerHook'.
	self cCode: 'compilerHooks[5]= nullCompilerHook'.
	self cCode: 'compilerHooks[6]= nullCompilerHook'.
	self cCode: 'compilerHooks[7]= nullCompilerHook'.
	self cCode: 'compilerHooks[8]= nullCompilerHook'.
	self cCode: 'compilerHooks[9]= nullCompilerHook'.
	self cCode: 'compilerHooks[10]= nullCompilerHook'.
	self cCode: 'compilerHooks[11]= nullCompilerHook'.
	self cCode: 'compilerHooks[12]= nullCompilerHook'.
	self cCode: 'compilerHooks[13]= nullCompilerHook'.
	self cCode: 'compilerHooks[14]= nullCompilerHook'.
	self cCode: 'compilerHooks[15]= nullCompilerHook'.
	self cCode: 'compilerHooks[16]= nullCompilerHook'.
	self cCode: 'compilerHooks[17]= nullCompilerHook'.
	self cCode: 'compilerHooks[18]= nullCompilerHook'.
	self cCode: 'compilerHooks[19]= nullCompilerHook'.
	self cCode: 'compilerHooks[20]= nullCompilerHook'.

	compilerInitialized := false! !

!Interpreter methodsFor: 'initialization' stamp: 'JMM 10/8/2006 23:01'!
initializeInterpreter: bytesToShift 
	"Initialize Interpreter state before starting execution of a new image."
	interpreterProxy := self sqGetInterpreterProxy.
	self dummyReferToProxy.
	self initializeObjectMemory: bytesToShift.
	self initCompilerHooks.
	activeContext := nilObj.
	theHomeContext := nilObj.
	method := nilObj.
	receiver := nilObj.
	messageSelector := nilObj.
	newMethod := nilObj.
	methodClass := nilObj.
	lkupClass := nilObj.
	receiverClass := nilObj.
	newNativeMethod := nil.
	self flushMethodCache.
	self loadInitialContext.
	self initialCleanup.
	interruptCheckCounter := 0.
	interruptCheckCounterFeedBackReset := 1000.
	interruptChecksEveryNms := 1.
	nextPollTick := 0.
	nextWakeupTick := 0.
	lastTick := 0.
	interruptKeycode := 2094. "cmd-. as used for Mac but no other OS"
	interruptPending := false.
	semaphoresUseBufferA := true.
	semaphoresToSignalCountA := 0.
	semaphoresToSignalCountB := 0.
	deferDisplayUpdates := false.
	pendingFinalizationSignals := 0.
	globalSessionID := 0.
	[globalSessionID = 0]
		whileTrue: [globalSessionID := self
						cCode: 'time(NULL) + ioMSecs()'
						inSmalltalk: [(Random new next * SmallInteger maxVal) asInteger]]! !

!Interpreter methodsFor: 'interpreter shell' stamp: 'ikp 6/10/2004 11:01'!
fetchByte
	"This method uses the preIncrement builtin function which has no Smalltalk equivalent. Thus, it must be overridden in the simulator."

	^ self byteAtPointer: localIP preIncrement! !

!Interpreter methodsFor: 'object memory support' stamp: 'wbk 12/26/2004 22:56'!
mapInterpreterOops
	"Map all oops in the interpreter's state to their new values 
	during garbage collection or a become: operation."
	"Assume: All traced variables contain valid oops."
	| oop |
	nilObj := self remap: nilObj.
	falseObj := self remap: falseObj.
	trueObj := self remap: trueObj.
	specialObjectsOop := self remap: specialObjectsOop.
	compilerInitialized
		ifFalse: [stackPointer := stackPointer - activeContext. "*rel to active"
			activeContext := self remap: activeContext.
			stackPointer := stackPointer + activeContext. "*rel to active"
			theHomeContext := self remap: theHomeContext].
	instructionPointer := instructionPointer - method. "*rel to method"
	method := self remap: method.
	instructionPointer := instructionPointer + method. "*rel to method"
	receiver := self remap: receiver.
	messageSelector := self remap: messageSelector.
	newMethod := self remap: newMethod.
	methodClass := self remap: methodClass.
	lkupClass := self remap: lkupClass.
	receiverClass := self remap: receiverClass.
	self exuperyRemapObjectsHook.	"Remap objects that the compiler plugin uses"
	1 to: remapBufferCount do: [:i | 
			oop := remapBuffer at: i.
			(self isIntegerObject: oop)
				ifFalse: [remapBuffer at: i put: (self remap: oop)]]! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'JMM 10/8/2006 16:01'!
exuperyBlock: block Value: anInteger
	| blockEntry answer blockArguments localArgCount|
	self export: true.
	successFlag := true. 
	"Check the block is being called with the correct number of arguments"
	localArgCount := self fetchPointer: 4 ofObject: block.
	blockArguments :=self checkedIntegerValueOf: localArgCount.
	self success: (anInteger = blockArguments
		and: [(self fetchPointer: CallerIndex ofObject: block) = nilObj]).
	successFlag ifFalse: [^ nil].

	self storeContextRegisters: activeContext.

	self transfer: anInteger + 1
				fromIndex: self stackPointerIndex - anInteger + 1
				ofObject: activeContext
				toIndex: TempFrameStart
				ofObject: block.
	self 
		storeLong32: StackPointerIndex 
		ofObject: activeContext
		withValue: (self fetchPointer: StackPointerIndex ofObject: activeContext) - 
			((anInteger + 1) * 2).

	self storePointerUnchecked: SenderIndex ofObject: block withValue: activeContext.
	blockEntry := (self fetchPointer: 5 "IP" ofObject: block) - 1.
	activeContext := block.
	"Set the interpreter's stack pointer so the primitive code will set the block's
	stack pointer correctly"
	stackPointer := activeContext + BaseHeaderSize + (TempFrameStart - 1 * 4).
	newNativeMethod isNil
		ifTrue:
			[answer := self cCode: '( (int (*)())blockEntry)()'.
			self fetchContextRegisters: activeContext.]
		ifFalse: 
			[newNativeMethod := blockEntry].
! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'wbk 10/1/2006 20:41'!
exuperyCallMethod
	"Could move into compiled return sequence.
											It depends on how message sends end up working."

	| answer activeCntxt nativeMethod |
	self inline: false.
	activeCntxt := activeContext.
	nativeMethod := newNativeMethod.
	"Exupery only uses the active context, the rest it will get directly from the MethodContext object."
	self storeContextRegisters: activeContext.
	answer := self cCode: '( (int (*)(int))nativeMethod)(activeCntxt)'.
	self fetchContextRegisters: activeContext..
	^nil! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'wbk 10/2/2006 21:32'!
exuperyCompiledReturnAddress
	^self exuperyLookupReturnMethod: activeContext! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'wbk 10/3/2006 21:51'!
exuperyIsNativeContext: aContext
	self inline: true.
	self
		var: #aContext
		declareC: 'int *aContext'.
	^ (((aContext at: 4) bitAnd: 1) ~= 1 and: [((aContext at: 5) bitAnd: 1) ~= 0]) ! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'wbk 10/3/2006 21:36'!
exuperyLookupReturnMethod: aContext
	self
		var: #aContext
		declareC: 'int *aContext'.
	(self exuperyIsNativeContext: aContext) ifFalse: [^ nil].
	^ (aContext at: 2) - 1. "return the detagged return address, which must be aligned to a 2 byte boundary	
							because of tagging"	! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'JMM 10/8/2006 16:01'!
exuperyPush: localVal 
	| sp |
	sp := self 
				fetchPointer: StackPointerIndex
				ofObject: activeContext.
	sp := sp + 2.
	self 
		storeLong32: StackPointerIndex
		ofObject: activeContext
		withValue: sp.
	self 
		storeLong32: ReceiverIndex + (sp / 2)
		ofObject: activeContext
		withValue: localVal! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'wbk 10/3/2006 21:52'!
exuperyReturn
	| activeCntxt aFunction cntxt |
	self inline: true.
	self
		var: #cntxt
		declareC: 'int *cntxt'.
	cntxt := activeContext.
	aFunction := (cntxt at: 2) - 1.
	self var: #aFunction
		declareC: 'int (*aFunction) (int)'.
	activeCntxt := activeContext.
	self cCode: 'aFunction (activeCntxt)'.
	self fetchContextRegisters: activeContext.! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'JMM 10/8/2006 16:01'!
exuperySetup: selector Message: argumentsInteger Send: picPosition
	|rcvr rcvrClass|
	self export: true. "allow lookup from elsewhere, e.g., plugin"
	self inline: false. 
	" Reload the context here, the interpreter code below depends on it."
	self fetchContextRegisters: activeContext.

	"The send bytecode"
	messageSelector := selector.
	argumentCount := argumentsInteger.

	"normalSend"
	rcvr := self stackValue: argumentCount.
	lkupClass := self fetchClassOf: rcvr.
	receiverClass := lkupClass.
	self findNewMethodInClass: lkupClass.
	newNativeMethod = nil 
		ifTrue:
			[(receiverClass < youngStart and: [picPosition ~= 0]) ifTrue:
				[rcvrClass := receiverClass.
				self cCode: '*(int *) (picPosition + 12) = rcvrClass'
				"self
					longAt: (self cCoerce: (picPosition + 11) to: 'char *')
					put: receiverClass"].
			self exuperyExecuteNewMethod. 
			"executeNewMethod fetches the new context registers"
		 	"Load the stackPointer into the active context, it might have changed, e.g. if a primitive
			has been executed"
			self
				storeLong32:  StackPointerIndex	
				ofObject: activeContext
				withValue: (self integerObjectOf: (stackPointer - activeContext) / 4 - TempFrameStart)]
		ifFalse:
			[self 
				exuperyPopulatePic: picPosition
				with: newNativeMethod
				receiver: receiverClass].
	"fetchNextBytecode must be done inside the interpreter loop/function"
	^ newNativeMethod  ! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'JMM 10/8/2006 16:01'!
exuperySetup: selector Super: argumentsInteger Send: picPosition
	|rcvr rcvrClass|
	self export: true. "allow lookup from elsewhere, e.g., plugin"
	self inline: false. 
	" Reload the context here, the interpreter code below depends on it."
	self fetchContextRegisters: activeContext.

	"The send bytecode"
	messageSelector := selector.
	argumentCount := argumentsInteger.

	"normalSend"
	"The following lines are all that's different between this and normal sends"
	lkupClass := self superclassOf: (self methodClassOf: method).
	rcvr := self stackValue: argumentCount.
	receiverClass := self fetchClassOf: rcvr.
	
	self findNewMethodInClass: lkupClass.
	newNativeMethod = nil 
		ifTrue:
			[(receiverClass < youngStart and: [picPosition ~= 0]) ifTrue:
				[rcvrClass := receiverClass.
				self cCode: '*(int *) (picPosition + 12) = rcvrClass'
				"self
					longAt: (self cCoerce: (picPosition + 11) to: 'char *')
					put: receiverClass"].
			self exuperyExecuteNewMethod. 
			"executeNewMethod fetches the new context registers"
		 	"Load the stackPointer into the active context, it might have changed, e.g. if a primitive
			has been executed"
			self
				storeLong32:  StackPointerIndex	
				ofObject: activeContext
				withValue: (self integerObjectOf: (stackPointer - activeContext) / 4 - TempFrameStart)]
		ifFalse:
			[self 
				exuperyPopulatePic: picPosition
				with: newNativeMethod
				receiver: receiverClass].
	"fetchNextBytecode must be done inside the interpreter loop/function"

	^ newNativeMethod  ! !

!Interpreter methodsFor: '*Exupery-Sends and Returns' stamp: 'JMM 10/8/2006 16:02'!
exupery: argCnt Create: tmpCnt Context: isLargeContext
	| newContext  nilOop where | 
	self export: true.	"allow lookup from elsewhere, e.g., plugin"
	
 	"A GC needs the IP and SP set so it can resave them"
	self fetchContextRegisters: activeContext.
	newContext := self allocateOrRecycleContext: isLargeContext.	"Assume: newContext will be recorded as a root if necessary by the call to newActiveContext: below, so we can use unchecked stores."

	
	where := newContext + BaseHeaderSize.
	self 
		longAt: where + (SenderIndex << 2)
		put: activeContext.
	self  "REMOVE, now redundant"
		longAt: where + (MethodIndex << 2)
		put: newMethod.
	self
		longAt: where + (4 "Unused slot, Used as a type marker" <<2)
		put: 1. "A zero"	
	self
		storeLong32: StackPointerIndex
		ofObject: newContext
		withValue: 1.
	self
		storeLong32: InstructionPointerIndex
		ofObject: newContext
		withValue: 1.
	newContext < youngStart ifTrue: [self beRootIfOld: newContext].
	"Copy the reciever and arguments..."
	0 
		to: argCnt
		do: 
			[:i | 
			self 
				longAt: where + (ReceiverIndex + i << 2)
				put: (self stackValue: argCnt - i)].	"clear remaining temps to nil in case it has been recycled"
	nilOop := nilObj.
	argCnt + 1 + ReceiverIndex 
		to: tmpCnt + ReceiverIndex
		do: 
			[:i | 
			self 
				longAt: where + (i << 2)
				put: nilOop].
	self pop: argCnt + 1.
	reclaimableContextCount := reclaimableContextCount + 1.
	"self storeContextRegisters: activeContext."
	self storeLong32: StackPointerIndex ofObject: activeContext
		withValue: (self integerObjectOf: (self stackPointerIndex - TempFrameStart + 1)).

	activeContext := newContext.
	"self fetchContextRegisters: newContext"! !


!Interpreter class methodsFor: 'initialization' stamp: 'wbk 4/12/2004 00:11'!
initializeCompilerHooks
	"Interpreter initializeCompilerHooks"

	"compilerHooks[] indices:
	1	void compilerTranslateMethodHook(void)
	2	void compilerFlushCacheHook(CompiledMethod *oldMethod)
	3	void compilerPreGCHook(int fullGCFlag)
	4	void compilerMapHook(int memStart, int memEnd)
	5	void compilerPostGCHook(void)
	6	void compilerProcessChangeHook(void)
	7	void compilerPreSnapshotHook(void)
	8	void compilerPostSnapshotHook(void)
	9	void compilerMarkHook(void)
	10	void compilerActivateMethodHook(void)
	11	void compilerNewActiveContextHook(int sendFlag)
	12	void compilerGetInstructionPointerHook(void)
	13	void compilerSetInstructionPointerHook(void)
	14	void compilerCreateActualMessageHook(void)"

	"Added a few more compiler hooks for Exupery's use"
	CompilerHooksSize _ 25.! !

Interpreter removeSelector: #exuperyCallMethodHook!
Interpreter removeSelector: #exuperyCompiledReturnAddressFor:!
Interpreter removeSelector: #exuperyCompiledReturn:!
Interpreter removeSelector: #exuperyRegisterReturnMethod:!
Interpreter removeSelector: #exuperyReturnHook!
Interpreter removeSelector: #exuperyReturn:!
